/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets;

import com.moulberry.axiom.packets.AxiomServerboundPacket;
import com.moulberry.axiom.utils.NetworkHelper;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3558;
import net.minecraft.class_3965;
import net.minecraft.class_4076;
import net.minecraft.class_7477;
import net.minecraft.class_8528;
import net.minecraft.server.MinecraftServer;

public class AxiomServerboundSetBlock
implements AxiomServerboundPacket {
    private static final class_2960 IDENTIFIER = new class_2960("axiom:set_block");
    private final Map<class_2338, class_2680> blocks;
    private final boolean updateNeighbors;
    private final int reason;
    private final boolean breaking;
    private final class_3965 blockHit;
    private final class_1268 hand;
    private final int sequenceId;
    public static final int REASON_REPLACEMODE = 1;
    public static final int REASON_TINKER = 2;
    public static final int REASON_FORCEPLACE = 4;
    public static final int REASON_NOUPDATES = 8;
    public static final int REASON_CUSTOMSHAPEUPDATE = 16;
    public static final int REASON_CUSTOMPLACEMENT = 32;
    public static final int REASON_INFINITEREACH = 64;
    public static final int REASON_ANGEL = 128;
    public static final int REASON_SYMMETRY = 256;

    public AxiomServerboundSetBlock(Map<class_2338, class_2680> blocks, boolean updateNeighbors, int reason, boolean breaking, class_3965 blockHitResult, class_1268 interactionHand, int sequenceId) {
        this.blocks = Map.copyOf(blocks);
        this.updateNeighbors = updateNeighbors;
        this.reason = reason;
        this.breaking = breaking;
        this.blockHit = blockHitResult;
        this.hand = interactionHand;
        this.sequenceId = sequenceId;
    }

    public AxiomServerboundSetBlock(class_2540 friendlyByteBuf) {
        this.blocks = friendlyByteBuf.method_34067(buf -> buf.method_10811(), NetworkHelper::readBlockState);
        this.updateNeighbors = friendlyByteBuf.readBoolean();
        this.reason = friendlyByteBuf.method_10816();
        this.breaking = friendlyByteBuf.readBoolean();
        this.blockHit = friendlyByteBuf.method_17814();
        this.hand = (class_1268)friendlyByteBuf.method_10818(class_1268.class);
        this.sequenceId = friendlyByteBuf.method_10816();
    }

    @Override
    public class_2960 id() {
        return IDENTIFIER;
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        friendlyByteBuf.method_34063(this.blocks, (buf, pos) -> buf.method_10807(pos), NetworkHelper::writeBlockState);
        friendlyByteBuf.writeBoolean(this.updateNeighbors);
        friendlyByteBuf.method_10804(this.reason);
        friendlyByteBuf.writeBoolean(this.breaking);
        friendlyByteBuf.method_17813(this.blockHit);
        friendlyByteBuf.method_10817((Enum)this.hand);
        friendlyByteBuf.method_10804(this.sequenceId);
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        class_2338 clickedPos;
        if (AxiomServerboundPacket.isMissingPermission(server, player)) {
            return;
        }
        if (this.sequenceId >= 0) {
            player.field_13987.method_41255(this.sequenceId);
        }
        if (this.breaking) {
            class_3218 serverLevel = player.method_51469();
            class_2680 block = serverLevel.method_8320(this.blockHit.method_17777());
            class_2586 class_25862 = serverLevel.method_8321(this.blockHit.method_17777());
            class_1269 attackResult = ((AttackBlockCallback)AttackBlockCallback.EVENT.invoker()).interact((class_1657)player, (class_1937)serverLevel, class_1268.field_5808, this.blockHit.method_17777(), this.blockHit.method_17780());
            if (attackResult != class_1269.field_5811) {
                return;
            }
            boolean breakBlockResult = ((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak((class_1937)serverLevel, (class_1657)player, this.blockHit.method_17777(), block, class_25862);
            if (!breakBlockResult) {
                return;
            }
        } else {
            class_1269 result = ((UseBlockCallback)UseBlockCallback.EVENT.invoker()).interact((class_1657)player, (class_1937)player.method_51469(), this.hand, this.blockHit);
            if (result != class_1269.field_5811) {
                return;
            }
        }
        class_1750 blockPlaceContext = new class_1750((class_1657)player, this.hand, player.method_5998(this.hand), this.blockHit);
        if (this.updateNeighbors) {
            for (Map.Entry entry : this.blocks.entrySet()) {
                player.method_37908().method_8652((class_2338)entry.getKey(), (class_2680)entry.getValue(), 3);
            }
        } else {
            for (Map.Entry entry : this.blocks.entrySet()) {
                boolean nowHasOnlyAir;
                class_2338 blockPos = (class_2338)entry.getKey();
                class_2680 blockState = (class_2680)entry.getValue();
                int bx = blockPos.method_10263();
                int by = blockPos.method_10264();
                int bz = blockPos.method_10260();
                int x = bx & 0xF;
                int y = by & 0xF;
                int z = bz & 0xF;
                int cx = bx >> 4;
                int cy = by >> 4;
                int cz = bz >> 4;
                class_3218 level = player.method_51469();
                class_2818 chunk = level.method_8497(cx, cz);
                chunk.method_12008(true);
                int sectionIndex = level.method_31603(cy);
                if (sectionIndex < 0 || sectionIndex >= level.method_32890()) continue;
                class_2826 section = chunk.method_38259(sectionIndex);
                boolean hasOnlyAir = section.method_38292();
                class_2902 worldSurface = null;
                class_2902 oceanFloor = null;
                class_2902 motionBlocking = null;
                class_2902 motionBlockingNoLeaves = null;
                for (Map.Entry heightmap : chunk.method_12011()) {
                    switch ((class_2902.class_2903)heightmap.getKey()) {
                        case field_13202: {
                            worldSurface = (class_2902)heightmap.getValue();
                            break;
                        }
                        case field_13200: {
                            oceanFloor = (class_2902)heightmap.getValue();
                            break;
                        }
                        case field_13197: {
                            motionBlocking = (class_2902)heightmap.getValue();
                            break;
                        }
                        case field_13203: {
                            motionBlockingNoLeaves = (class_2902)heightmap.getValue();
                            break;
                        }
                    }
                }
                class_2680 old = section.method_12256(x, y, z, blockState, true);
                if (blockState != old) {
                    class_2248 block = blockState.method_26204();
                    motionBlocking.method_12597(x, by, z, blockState);
                    motionBlockingNoLeaves.method_12597(x, by, z, blockState);
                    oceanFloor.method_12597(x, by, z, blockState);
                    worldSurface.method_12597(x, by, z, blockState);
                    if (blockState.method_31709()) {
                        class_2586 blockEntity = chunk.method_12201(blockPos, class_2818.class_2819.field_12859);
                        if (blockEntity == null) {
                            blockEntity = ((class_2343)block).method_10123(blockPos, blockState);
                            if (blockEntity != null) {
                                chunk.method_12216(blockEntity);
                            }
                        } else if (blockEntity.method_11017().method_20526(blockState)) {
                            blockEntity.method_31664(blockState);
                            chunk.method_31723(blockEntity);
                        } else {
                            chunk.method_12041(blockPos);
                            blockEntity = ((class_2343)block).method_10123(blockPos, blockState);
                            if (blockEntity != null) {
                                chunk.method_12216(blockEntity);
                            }
                        }
                    } else if (old.method_31709()) {
                        chunk.method_12041(blockPos);
                    }
                    level.method_14178().method_14128(blockPos);
                    if (class_3558.method_51561((class_1922)chunk, (class_2338)blockPos, (class_2680)old, (class_2680)blockState)) {
                        class_8528 sources = chunk.method_12018();
                        if (sources != null) {
                            sources.method_51536((class_1922)chunk, x, by, z);
                        }
                        level.method_14178().method_17293().method_15513(blockPos);
                    }
                    Optional newPoi = class_7477.method_43989((class_2680)blockState);
                    Optional oldPoi = class_7477.method_43989((class_2680)old);
                    if (!Objects.equals(oldPoi, newPoi)) {
                        if (oldPoi.isPresent()) {
                            level.method_19494().method_19112(blockPos);
                        }
                        newPoi.ifPresent(holder -> level.method_19494().method_19115(blockPos, holder));
                    }
                }
                if (hasOnlyAir == (nowHasOnlyAir = section.method_38292())) continue;
                level.method_14178().method_17293().method_15551(class_4076.method_18676((int)cx, (int)cy, (int)cz), nowHasOnlyAir);
            }
        }
        if (!this.breaking && this.blocks.containsKey(clickedPos = blockPlaceContext.method_8037())) {
            class_1799 class_17992 = player.method_5998(this.hand);
            class_2680 blockState = player.method_37908().method_8320(clickedPos);
            class_1747.method_7714((class_1937)player.method_37908(), (class_1657)player, (class_2338)clickedPos, (class_1799)class_17992);
            class_2248 block = blockState.method_26204();
            if (!(block instanceof class_2244 || block instanceof class_2320 || block instanceof class_2323)) {
                blockState.method_26204().method_9567(player.method_37908(), clickedPos, blockState, (class_1309)player, class_17992);
            }
        }
    }

    public static void register() {
        AxiomServerboundPacket.register(IDENTIFIER, AxiomServerboundSetBlock::new);
    }
}

